	function PLOT_IDEAL_IMPULSE_RESPONSE_S(Wc, t)
	
	%	Plots the impulse response of an ideal analog filter
	%	with bandwidth wc over the interval -t to +t
	
	% 	Toolbox for DIGITAL FILTERS USING MATLAB
	
	% Author: 			Lars Wanhammar 2005-11-11
	% Modified by: 	 	
	% Copyright:		by authors - not released for commercial use
	% Version:			1
	% Known bugs:		
	% Report bugs to:	Wanhammar@gmail.com
	
	%========================================================	
	% Standard settings
	fs = 16; 		% Font size
	lw = 2; 		% Linewidth
	fn = 'times'; 	% Font
	%========================================================
	
	t_axis = [-t:0.01:t];
	h_of_t =  sin(Wc*t_axis);
	x0 = find(t_axis == 0);
	t_axis(x0) = 1;
	h_of_t =  sin(Wc*t_axis)./(pi*t_axis);
	h_of_t(x0) = Wc/pi;
	t_axis(x0) = 0;
	
	plot(t_axis,h_of_t,'linewidth', lw);
	stem(t_axis,h_of_t,'filled')	
	axis([-t t min(h_of_t)-0.1 max(h_of_t)+0.1]); %  This may be changed to get a neater plot
	ylabel('{\ith}({\itt})','FontName', fn,'FontSize',fs);
	xlabel('\itt ','FontName', fn,'FontSize', fs);
	set(gca,'FontName', fn,'FontSize', fs);
	grid on;
	zoom on	
	
	
